package com.example.android.dialogs;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import android.widget.Toast;

import java.util.Calendar;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

            //Standard Dialog
    public void alertDialog(View v)  {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(MainActivity.this);
        alertBuilder.setTitle("Confirmation Message");
        alertBuilder.setMessage("Sure to delete this content");
        alertBuilder.setPositiveButton("Yes", new DialogInterface.OnClickListener()  {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Toast.makeText(MainActivity.this, "Positive Confirmation",
                        Toast.LENGTH_LONG).show();
                dialog.cancel();  }; });
        alertBuilder.setNegativeButton("No", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Toast.makeText(MainActivity.this, "Negative Confirmation",Toast.LENGTH_LONG).show();
                dialog.cancel();} });
        AlertDialog ad = alertBuilder.create();
        ad.show() ;
    }


    //Date

    public void date(View v) {

        Calendar cal1 = Calendar.getInstance();
        // Instantiate a DatePickerDialog Class (android.app.DatePickerDialog)
        DatePickerDialog datePickerDialog = new DatePickerDialog(this,
                new DatePickerDialog.OnDateSetListener() {
                    public void onDateSet(DatePicker view, int year,
                                          int monthOfYear, int dayOfMonth) {

                        (Toast.makeText(getApplicationContext(),
                                "On DateSet:" + year + ":" + monthOfYear +
                                        dayOfMonth + " ", Toast.LENGTH_LONG)).show();
                    }
                }, cal1.get(Calendar.YEAR),
                cal1.get(Calendar.MONTH),
                cal1.get(Calendar.DAY_OF_MONTH));
        datePickerDialog.show();
    }

    public void time(View v) {

        Calendar cal2 = Calendar.getInstance();
        TimePickerDialog timePickerDialog = new TimePickerDialog(this, new
                TimePickerDialog.OnTimeSetListener() {
                    @Override
                    public void onTimeSet(TimePicker arg0, int hourOfDay, int minute) {
                        (Toast.makeText(getApplicationContext(),
                                "On Time Set:" + hourOfDay + ":" +
                                minute + " ", Toast.LENGTH_LONG)).show();
                    }
                }, cal2.get(Calendar.HOUR_OF_DAY),
                cal2.get(Calendar.MINUTE), false);

        timePickerDialog.show();
    }

    private ProgressDialog progress;

    public void progress(View v) {
        progress=new ProgressDialog(this);
        progress.setMessage("Downloading Music");
        progress.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        progress.setIndeterminate(true);
        progress.setProgress(0);
        progress.show();

        final int totalProgressTime = 100;
        final Thread t = new Thread() {
            @Override
            public void run() {
                int jumpTime = 0;

                while(jumpTime < totalProgressTime) {
                    try {
                        sleep(200);
                        jumpTime += 5;
                        progress.setProgress(jumpTime);
                    } catch (InterruptedException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
    }

    }




